/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class ShockSlug
extends AbstractCard {
    public static final String ID = "ShockSlug";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("ShockSlug");
    public static final String NAME = "Shock Slug";
    public static final String DESCRIPTION = "Deal !D! damage. NL Gain !B! Block.";
    private static final int COST = 2;
    private static final int DAMAGE_AMT = 4;
    private static final int BLOCK_AMT = 4;
    private static final int POOL = 1;

    public ShockSlug() {
        super(ID, NAME, null, 2, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.subType = AbstractCard.CardSubType.AMMO;
        this.baseDamage = 4;
        this.baseBlock = 4;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new GainBlockAction(p, p, this.block));
        AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)m, new DamageInfo(p, this.damage, this.damageTypeForTurn), AbstractGameAction.AttackEffect.FIRE));
    }

    @Override
    public void fire(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m);
    }

    @Override
    public AbstractCard makeCopy() {
        return new ShockSlug();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeBlock(2);
            this.upgradeDamage(2);
        }
    }
}

